/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.modifiers.adding;

import com.google.gson.JsonObject;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import slimeknights.mantle.recipe.data.AbstractRecipeBuilder;
import slimeknights.tconstruct.tools.TinkerModifiers;

public class OverslimeModifierRecipeBuilder
extends AbstractRecipeBuilder<OverslimeModifierRecipeBuilder> {
    private final Ingredient ingredient;
    private final int restoreAmount;

    public static OverslimeModifierRecipeBuilder modifier(ItemLike item, int restoreAmount) {
        return OverslimeModifierRecipeBuilder.modifier(Ingredient.m_43929_((ItemLike[])new ItemLike[]{item}), restoreAmount);
    }

    public void save(Consumer<FinishedRecipe> consumer) {
        ItemStack[] stacks = this.ingredient.m_43908_();
        if (stacks.length == 0) {
            throw new IllegalStateException("Empty ingredient not allowed");
        }
        this.save(consumer, Objects.requireNonNull(stacks[0].m_41720_().getRegistryName()));
    }

    public void save(Consumer<FinishedRecipe> consumer, ResourceLocation id) {
        if (this.ingredient == Ingredient.f_43901_) {
            throw new IllegalStateException("Empty ingredient not allowed");
        }
        ResourceLocation advancementId = this.buildOptionalAdvancement(id, "modifiers");
        consumer.accept((FinishedRecipe)new Finished(id, advancementId));
    }

    private OverslimeModifierRecipeBuilder(Ingredient ingredient, int restoreAmount) {
        this.ingredient = ingredient;
        this.restoreAmount = restoreAmount;
    }

    public static OverslimeModifierRecipeBuilder modifier(Ingredient ingredient, int restoreAmount) {
        return new OverslimeModifierRecipeBuilder(ingredient, restoreAmount);
    }

    private class Finished
    extends AbstractRecipeBuilder.AbstractFinishedRecipe {
        public Finished(@Nullable ResourceLocation ID, ResourceLocation advancementID) {
            super((AbstractRecipeBuilder)OverslimeModifierRecipeBuilder.this, ID, advancementID);
        }

        public void m_7917_(JsonObject json) {
            json.add("ingredient", OverslimeModifierRecipeBuilder.this.ingredient.m_43942_());
            json.addProperty("restore_amount", (Number)OverslimeModifierRecipeBuilder.this.restoreAmount);
        }

        public RecipeSerializer<?> m_6637_() {
            return (RecipeSerializer)TinkerModifiers.overslimeSerializer.get();
        }
    }
}

